/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: pgpDialogTTY.cpp,v 1.7 2000/05/15 22:47:28 hal Exp $
____________________________________________________________________________*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "pgpDialogs.h"
#include "pgpPassphraseUtils.h"
#include "pgpErrors.h"
#include "pgpKeys.h"
#include "pgpDebug.h"

static void GetKeyString(PGPKeyDBObjRef Key,char *szNameFinal);

	PGPError
pgpRecipientDialogTTY(
	PGPContextRef				context,
	CPGPRecipientDialogOptions 	*options)
{
	PGPKeyListRef	SRCKeyList, KeyList;
	PGPKeyIterRef	SRCKeyIter, KeyIter;
	PGPKeyDBObjRef	Key;
	PGPKeySetRef	set_ref;
	int n;
	PGPError err;

	pgpAssert( PGPContextRefIsValid( context ) );
	pgpAssert( PGPKeySetRefIsValid( options->mClientKeySet ) );

	err = PGPOrderKeySet(options->mClientKeySet, kPGPKeyOrdering_Any, FALSE, &SRCKeyList);
	if (IsPGPError(err)) return err;

	err = PGPNewKeyIter(SRCKeyList, &SRCKeyIter);
	if (IsPGPError(err)) return err;

	printf("Select Recipients From List:\n");
	printf("-------------------------------------------------------------------\n");
	n = 1;
	while ( IsntPGPError(PGPKeyIterNextKeyDBObj(SRCKeyIter, kPGPKeyDBObjType_Key, &Key)) ) {
		char buf[256];
		GetKeyString(Key, buf);
		printf("%3d %s\n", n++, buf);
	}
	
	options->mNewKeys = options->mRecipientKeysPtr;
	PGPNewKeySet(*(options->mRecipientKeysPtr), &set_ref);

	for(;;) {
		char cmdbuf[80];
		printf("]> ");
		gets(cmdbuf);
		switch(*cmdbuf) {
		case 'r':
			err = PGPOrderKeySet(set_ref, kPGPKeyOrdering_Any, FALSE, &KeyList);
			if (IsPGPError(err)) return err;

			err = PGPNewKeyIter(KeyList, &KeyIter);
			if (IsPGPError(err)) return err;

			printf("Recipients:\n");
			printf("-------------------------------------------------------------------\n");
			n = 1;

			for(;;) {
				char buf[256];
				err = PGPKeyIterNextKeyDBObj(KeyIter, kPGPKeyDBObjType_Key, &Key);
				if (IsPGPError(err)) break;
				GetKeyString(Key, buf);
				printf("%3d %s\n", n++, buf);
			}

			PGPFreeKeyIter(KeyIter);
			PGPFreeKeyList(KeyList);
			break;
		case 'l':
			printf("Select Recipients From List:\n");
			printf("-------------------------------------------------------------------\n");
			PGPKeyIterRewind(SRCKeyIter, kPGPKeyDBObjType_Key);
			n = 1;
			while ( IsntPGPError( PGPKeyIterNextKeyDBObj(SRCKeyIter, kPGPKeyDBObjType_Key, &Key) )) {
				char buf[256];
				GetKeyString(Key, buf);
				printf("%3d %s\n", n++, buf);
			}
			break;
		case 'q':
			PGPFreeKeyIter(SRCKeyIter);
			PGPFreeKeyList(SRCKeyList);
			return kPGPError_NoErr;
		default:
			if (isdigit(*cmdbuf)) {
				char buf[256];
				int num = atoi(cmdbuf);
				if (num < 1) {
					printf("Invalid Index\n");
					continue;
				}
				PGPKeyIterRewind(SRCKeyIter, kPGPKeyDBObjType_Key);
				err = PGPKeyIterMove(SRCKeyIter, num, &Key);
				if (IsPGPError(err)) {
					printf("Invalid Index\n");
					continue;
				}
				GetKeyString(Key, buf);
				printf("ADD %s\n", buf);
				PGPCopyKeyDBObj( Key, *options->mNewKeys, NULL);
			}
			else
				printf("Valid commands: {num} c)lear l)ist r)ecipients q)uit\n");
		}
	}

	PGPFreeKeyIter(SRCKeyIter);
	PGPFreeKeyList(SRCKeyList);

	return kPGPError_NoErr;
}

static void
GetKeyString(PGPKeyDBObjRef Key,char *szNameFinal)
{
	char			sz1[32],sz2[32];
	char			szName[kPGPMaxUserIDSize];
	PGPUInt32		uAlgorithm,uKeyBits;
	PGPSize			u;
	PGPBoolean bValidity;

	PGPGetKeyDBObjBooleanProperty (Key, kPGPKeyProperty_Validity, &bValidity);

	PGPGetKeyDBObjNumericProperty (Key, kPGPKeyProperty_AlgorithmID, (int *)&uAlgorithm);

	strcpy (sz2, "(");
	switch (uAlgorithm) 
	{
	case kPGPPublicKeyAlgorithm_RSA :
		strcat (sz2, "RSA/");
		PGPGetKeyDBObjNumericProperty (Key, kPGPKeyProperty_Bits, (int *)&uKeyBits);
		sprintf (sz1, "%i", uKeyBits);
		strcat (sz2, sz1);
		break;
		
	case kPGPPublicKeyAlgorithm_DSA :
		strcat (sz2, "DSS/");
		PGPGetKeyDBObjNumericProperty (Key, kPGPKeyProperty_Bits, (int *)&uKeyBits);
		sprintf (sz1, "%i", uKeyBits);
		strcat (sz2, sz1);
		break;
		
	default :
		strcat (sz2, "Unknown/Unknown");
		break;
	}
	
	strcat (sz2, ")");

	PGPGetPrimaryUserIDName(Key, szName, sizeof(szName), &u);
	szName[u] = '\0';
	if (strlen(szName) > 50)
		strcpy(&szName[47],"...");

	sprintf(szNameFinal, "%-50s %c %11s", szName, bValidity ? '*' : ' ', sz2);
}
